<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewInstallation extends JView
{
	function display( $tpl = null)
	{
		// Load the installation language file
		$lang =& JFactory::getLanguage();
		$lang->load( 'com_jam.install');

		// Initialize some vars
		JAMLoad::_('helper', 'installation');
		$model		=& JAMLoad::Object('model', 'installation');
		$install	= array();
		$upgrade	= array();
		$check		= true;

		/*
		 * Create JAM's tables if they do not exists
		 */
		$tables = $model->CheckTables();
		if (!$tables['jam']) {
			$check		= false;
			// Create the message table
			$data		= JAMHelperInstallation::getTableData( 'jam' );
			$install[]	= array( JText::_('Table creation'), $model->CreateTable( 'jam', $data) );
		}
		if (!$tables['receivers']) {
			// Create the receivers table
			$data		= JAMHelperInstallation::getTableData( 'jam_receivers' );
			$install[]	= array( JText::_('Table creation'), $model->CreateTable( 'jam_receivers', $data) );
		}
		if (!$tables['settings']) {
			// Create the settings table
			$data		= JAMHelperInstallation::getTableData( 'jam_settings' );
			$install[]	= array( JText::_('Table creation'), $model->CreateTable( 'jam_settings', $data) );
		}
		if (!$tables['tags']) {
			// Create the tags table
			$data		= JAMHelperInstallation::getTableData( 'jam_tags' );
			$install[]	= array( JText::_('Table creation'), $model->CreateTable( 'jam_tags', $data) );
		}

		/*
		 * No upgrade needed: show the page
		 */
		if (!$check)
		{
			/*
			 * Install the standard config
			 */
			$install[]	= array( JText::_('Standard Configuration'), JAMHelperInstallation::config() );
	
			$this->assign( 'install', $install);
			$this->assign( 'upgrade', $upgrade);

			return true;
		}

		/*
		 * Upgrade JAM's tables where needed
		 */
		$table_jam		= $model->getTableColumns('jam');
		$table_settings	= $model->getTableColumns('jam_settings');

		/* JAM v1.0.2 */
		if (isset($table_jam['tags']))
		{
			jimport('joomla.filesystem.file');
			$db =& $model->db;

			// Tags implented with a separated teble
			$db->setQuery( 'ALTER TABLE `'.$db->getPrefix().'jam` DROP `tags`' );
			$upgrade[] = array( JText::_('Table upgrade'), $db->query() ? true : $db->stderr() );		
			$db->setQuery( 'ALTER TABLE `'.$db->getPrefix().'jam_receivers` DROP `tags`' );
			$upgrade[] = array( JText::_('Table upgrade'), $db->query() ? true : $db->stderr() );

			// New folder "includes", with has some no-librarie files
			$upgrade[]	= array( JText::_('File deletion'), JFile::delete(JPATH_COMPONENT_SITE.DS.'libraries'.DS.'users.php') );
			$upgrade[]	= array( JText::_('File deletion'), JFile::delete(JPATH_COMPONENT_SITE.DS.'libraries'.DS.'template.php') );
			$upgrade[]	= array( JText::_('File deletion'), JFile::delete(JPATH_COMPONENT_SITE.DS.'libraries'.DS.'pagination.php') );
			$upgrade[]	= array( JText::_('File deletion'), JFile::delete(JPATH_COMPONENT_SITE.DS.'libraries'.DS.'editor.php') );
			
			// Librarie 'menu' merged with librarie 'html'
			$upgrade[]	= array( JText::_('File deletion'), JFile::delete(JPATH_COMPONENT_SITE.DS.'libraries'.DS.'menu.php') );
		}

		/*
		 * Install the standard config
		 */
		$upgrade[]	= array( JText::_('Standard Configuration'), JAMHelperInstallation::config() );

		$this->assign( 'install', $install);
		$this->assign( 'upgrade', $upgrade);

		parent::display($tpl);
	}
}
?>