<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewAll extends JView
{
	function display( $tpl = null)
	{
		$layout = $this->getLayout();

		if ($layout == 'read') {
			$this->_read($tpl);
			return;
		} else  {
			$this->_messages($tpl);
			return;
		}
	}

	function _messages( $tpl = null)
	{
		JAMLoad::_( 'helper' , 'all' );
		$config		=& JAMConfig::getConfig();
		$model      =& JAMLoad::Object( 'model', 'all' );
		$where		= array();
		$option		= 'jam.all';

		// Get some variables
		global $mainframe;
		$search				= $mainframe->getUserStateFromRequest("$option.search", 'search', '');
		$filter_state		= $mainframe->getUserStateFromRequest("$option.filter_state", 'filter_state', 5);
		$filter_order		= $mainframe->getUserStateFromRequest("$option.filter_order", 'filter_order', 'm.datetime');
		$filter_order_Dir	= $mainframe->getUserStateFromRequest("$option.filter_order_Dir", 'filter_order_Dir', 'DESC');
		$limit				= $mainframe->getUserStateFromRequest("$option.limit", 'limit', $mainframe->getCfg( 'list_limit'));
		$limitstart			= JRequest::getVar('limitstart', '0');

		// Message filter
		if ($filter_state != 0)
		{
			$where[] = JAMHelperAll::Filter_state($filter_state);
		}

		// Search
		if ($search) {
			$where[] = JAMHelperAll::SQLSearch($search);;
		}

		// Ordering
		$order = $filter_order.' '.$filter_order_Dir;

		// Get the total number of filtered messages
		$total = $model->countMessages($where);

		// Create the pagination object
		jimport( 'joomla.html.pagination');
		$pagination = new JPagination($total, $limitstart, $limit);

		// Get the messages
		$rows = $model->getMessages($where, $order, $limitstart, $limit); 

		// Search filter
		$lists['search'] = $search;

		// Messages filter
		$lists['state'] = JAMHelperAll::Filter_state_html( $filter_state);

		// Table ordering
		$lists['order']		= JAMHelperAll::Filter_order_html($filter_order);
		$lists['order_Dir']	= JAMHelperAll::Filter_order_Dir_html($filter_order_Dir);

		$this->assign( 'rows'		, $rows);
		$this->assign( 'lists'		, $lists);
		$this->assign( 'pageNav'	, $pagination);

		parent::display($tpl);
	}

	function _read( $tpl = null)
	{
		$config		=& JAMConfig::getConfig();
		$usersettings= JAMConfig::getUserSettings();
		$user		=& JFactory::getUser();
		$model      =& JAMLoad::Object( 'model', 'all' );

		$mid		= JRequest::getVar( 'id', 0, '', 'INT');

		// Get the message
		$result = $model->getMessage($mid);

		// Convert the messagetime into the user's timezone and the user's date format
		$result->datetime = JHTML::Date( $result->datetime, $usersettings->dateformat, $user->getParam('timezone', '0') );

		// Convert the priority into text
		if ($result->priority == '3') {
			$result->priority = JText::_('High');
		} else if ($result->priority == '1') {
			$result->priority = JText::_('Low');
		} else {
			$result->priority = JText::_('Normal');
		}

		// Add the attachments if they excists
		if ($result->attachments)
		{
			jimport('joomla.filesystem.folder');
			$attachments	= JFolder::files( JPATH_COMPONENT_SITE.DS.'attachments'.DS.$mid );
			$baseurl		= JURI::root().'components/com_jam/attachments/'.$mid.'/';
			foreach ($attachments as $attachment)
			{
				if ($attachment == 'index.html') {continue;}
				$array[]	= '<a href="'.$baseurl.$attachment.'" target="_blank">'.$attachment.'</a>';
			}
			$result->attachments = implode( ' - ', $array);
		}

		// Sender
		if ($result->sid == '1') {
			$user->user	= JText::_('Information message');
		} else
		{
			$select	= $config->get('displayuser');
			$sender =& JFactory::getUser($result->sid);
			if ($select == '1') {
				$sender = $sender->get('username');
			} else if ($select == '2') {
				$sender = $sender->get('name');
			} else if ($select == '3') {
				$sender = $sender->get('username').' ('.$sender->get('name').')';
			} else if ($select == '4') {
				$sender = $sender->get('name').' ('.$sender->get('username').')';
			}
			$result->from = $sender;
		}

		// Receivers
		if ($result->draft) {
			$result->user = JText::_('Draft').($result->user ? ': '.$result->user : null);
		} else {
			$result->to = $result->user;
		}

		// Remove the slashes from the message
		$result->subject = stripslashes($result->subject);
		$result->message = stripslashes($result->message);

		$this->assign( 'result', $result);

		parent::display($tpl);
	}
}
?>