<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

defined('_JEXEC') or die('Restricted access'); // no direct access  

$user			=& JFactory::getUser();
$usersettings	=& JAMConfig::getUserSettings();
if (!$usersettings) {
	$usersettings->dateformat = '%d-%b-%Y %H:%M';
}
?>
<form name="adminForm" id="JAMForm" action="index.php?option=com_jam&view=all" method="post">
<table class="adminform" width="100%">
	<tr>
		<td align="left" width="50%">
			<input type="text" name="search" value="<?php echo $this->lists['search']; ?>" class="inputbox" title="<?php echo JText::_( 'Search by user, subject and message'); ?>" size="20" />&nbsp;
			<input type="button" onclick="document.adminForm.submit();" value="<?php echo JText::_( 'Search'); ?>" />&nbsp;
			<input type="button" onclick="document.adminForm.search.value='';document.adminForm.submit();" value="<?php echo JText::_( 'Reset' ); ?>" />
		</td>
		<td align="right" width="50%" style="text-align:right;">
			<b><?php echo JText::_( 'Display'); ?></b> <?php echo JText::_( 'Num'); ?>
			<?php echo $this->pageNav->getLimitBox(); ?>
			&nbsp;<?php echo $this->lists['state']; ?>
			<br />
			<b><?php echo JText::_( 'Sort by'); ?></b>
			<?php echo $this->lists['order']; ?>
			&nbsp;<?php echo $this->lists['order_Dir']; ?>
		</td>
	</tr>
</table>

<table class="adminlist" cellspacing="1">
	<thead>
		<tr>
			<th width="1%" nowrap="nowrap"><?php echo JText::_( 'Num' ); ?></th>
			<th class="title"><?php echo JText::_( 'Users' ); ?></th>
			<th class="title"><?php echo JText::_( 'Subject' ); ?></th>
			<th width="10%"><?php echo JText::_( 'Date' ); ?></th>
			<th width="1%" nowrap="nowrap"><?php echo JText::_( 'Draft' ); ?></th>
			<th width="1%" nowrap="nowrap"><?php echo JText::_( 'System' ); ?></th>
			<th width="1%" nowrap="nowrap"><?php echo JText::_( 'Attachments' ); ?></th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="8"><?php echo $this->pageNav->getListFooter(); ?></td>
		</tr>
	</tfoot>
	<tbody>
		<?php if (!$this->rows) : ?>
		<tr>
			<td colspan="8"><h2 style="text-align:center;"><?php echo JText::_( 'No messages found'); ?></h2></td>
		</tr>
		<?php else :
		$k = 0;
		for ($i = 0, $t = count( $this->rows ); $i < $t; $i++)
		{
			$row = $this->rows[$i];
		?><tr class="<?php echo "row$k"; ?>">
			<td><?php echo $i + 1 + $this->pageNav->limitstart; ?></td>
			<td><?php echo $row->user; ?></td>
			<td><a href="index.php?option=com_jam&view=all&id=<?php echo $row->id; ?>&layout=read"><?php echo stripslashes( substr( $row->subject, 0, 100) ); ?>...</a></td>
			<td><?php echo JHTML::Date($row->datetime, $usersettings->dateformat, $user->getParam('timezone', '0'));; ?></td>
			<td align="center"><img src="./images/<?php echo $row->draft ? 'tick' : 'publish_x'; ?>.png" /></td>
			<td align="center"><img src="./images/<?php echo $row->system ? 'tick' : 'publish_x'; ?>.png" /></td>
			<td align="center"><img src="./images/<?php echo $row->attachments ? 'tick' : 'publish_x'; ?>.png" /></td>
		</tr>
		<?php
			$k = 1-$k;
		}
		endif;
		?>
	</tbody>
</table>
</form>