<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMToolbar
{
	function clean() {
		$bar =& JToolBar::getInstance('toolbar');
		$bar->appendButton( 'Standard', 'apply', 'Apply', 'clean', true, false );
	}

	function templates() {
		$bar =& JToolBar::getInstance('toolbar');
		$layout = JRequest::getVar('layout', 'default', 'post');
		if ($layout == 'fileslist') {
			$bar->appendButton( 'Standard', 'edit', 'Edit', '', true, false );
			$bar->appendButton( 'Link', 'back', 'Templates', 'index.php?option=com_jam&view=templates');
		} else if ($layout == 'editor') {
			$bar->appendButton( 'Standard', 'save', 'Save', 'savetemplate', false, false );
			$bar->appendButton( 'Link', 'back', 'Files', 'javascript:history.back();');
		} else {
			$bar->appendButton( 'Standard', 'default', 'Default', 'templatedefault', true, false );
			$bar->appendButton( 'Standard', 'html', 'Edit HTML', 'edithtml', true, false );
			$bar->appendButton( 'Standard', 'css', 'Edit CSS', 'editcss', true, false );
		}
	}

	function configuration() {
		$bar =& JToolBar::getInstance('toolbar');
		$bar->appendButton( 'Standard', 'save', 'Save', 'config', true, false );
	}

	function all() {
		$bar =& JToolBar::getInstance('toolbar');
		$layout = JRequest::getVar('layout', 'default', 'get');
		if ($layout == 'read') {
			$bar->appendButton( 'Link', 'back', 'All', 'index.php?option=com_jam&view=all');
		}
	}

	function title($view) {
		if ($view == 'inbox') {
			$view = 'jam';
		}
		JToolBarHelper::title( JText::_( 'Joomla Advanced Message').': '.JText::_($view), 'jam');
		$document =& JFactory::getDocument();
		$document->addStyleDeclaration( '.icon-48-jam {background:url(../components/com_jam/assets/jam48.png) no-repeat left;}' );
	}	

	function back() {
		$bar =& JToolBar::getInstance('toolbar');
		$bar->appendButton( 'Link', 'back', 'Panel', 'index.php?option=com_jam&view=panel');
	}
}
?>