<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.controller');

class JAMAdminController extends JController
{
	var $_mainframe = null;

	function __construct()
	{
		parent::__construct();

		global $mainframe;
		$this->_mainframe = $mainframe;
	}

	function clean()
	{
		$db		=& JFactory::getDBO();
		$clean	= JRequest::getVar( 'clean', '', 'POST', 'ARRAY');
		$option	= JRequest::getVar( 'option', '', 'POST', 'ARRAY');

		/*
		 * Remove selected messages
		 */
		if (isset($clean['old']) || isset($clean['information']) || isset($clean['system']))
		{
			// Load a librarie
			jimport('joomla.filesystem.folder');

			// Build the WHERE clause
			$where = array();
			if (isset($clean['information'])) {
				$time	= date('Y-m-d H:i:s', time() - ($option['information']*604800) );
				$where[]= "(sid = '1' AND datetime <= '$time')";
			}
			if (isset($clean['system'])) {
				$time	= date('Y-m-d H:i:s', time() - ($option['system']*604800) );
				$where[]= "(system = '1' AND datetime <= '$time')";
			}
			if (isset($clean['old'])) {
				$time	= date('Y-m-d H:i:s', time() - ($option['old']*604800) );
				$where[]= "datetime <= '$time'";
			}
			$where = implode( ' OR ', $where);

			/* Delete the messages */
			$ids = array();

			// Get some info of the selected message
			$query	= 'SELECT id, attachments'
					. ' FROM `#__jam`'
					. ' WHERE '.$where;
			$db->setQuery($query);
			$result = $db->loadAssocList();

			// Add messages ids to the array and delete attachments
			$basepath = JPATH_COMPONENT_SITE.DS.'attachments'.DS;
			for ($i = 0, $t = count($result); $i < $t; $i++) {
				$ids[] = $result[$i]['id'];
				if ($result[$i]['attachments']) {
					JFolder::delete( $basepath.$result[$i]['id'] );
				}
			}

			// Delete the messages from the database
			if ($ids)
			{
				$ids = implode(',', $ids);
				$db->setQuery( 'DELETE FROM `#__jam` WHERE id IN ('.$ids.');' );
				if (!$db->query()) {
					$this->_mainframe->redirect( 'index.php?option=com_jam&view=clean', $db->stderr(), 'error' );
				}
				$db->setQuery( 'DELETE FROM `#__jam_receivers` WHERE mid IN ('.$ids.');' );
				if (!$db->query()) {
					$this->_mainframe->redirect( 'index.php?option=com_jam&view=clean', $db->stderr(), 'error' );
				}
			}
		}

		/*
		 * Remove overhead
		 */
		if (isset( $clean['overhead'] )) {
			$db->setQuery( 'SHOW TABLES' );
			$tables = $db->loadResultArray();
			$tables = implode("`,`", $tables);
			$db->setQuery( "OPTIMIZE TABLE `$tables`");
			if (!$db->query()) {
				$this->_mainframe->redirect( 'index.php?option=com_jam&view=clean', $db->stderr(), 'error' );
			}
		}

		$message = JText::_( 'Successfully cleaned');
		$this->_mainframe->redirect( 'index.php?option=com_jam&view=clean', $message );
	}

	function templatedefault()
	{
		// Get the selected template
		$template	= JRequest::getVar( 'cid', '', 'post', 'array');
		$template	= $template[0];

		// Get the current config
		$config		=& JAMConfig::getConfig();
		$params		= $config->toArray();

		// Get the database table of the our component
		$table = JTable::getInstance('component');
		if (!$table->loadByOption( 'com_jam')) {
			$this->_mainframe->redirect( 'index.php?option=com_jam&view=templates', JText::_('ERRORELEMENTNOTFOUND'), 'error' );
		}

		// Update the config
		$params['template_default'] = $template;
		$table->bind( array('params' => $params) );

		// Pre-save checks
		if (!$table->check()) {
			$this->_mainframe->redirect( 'index.php?option=com_jam&view=templates', $table->getError(), 'error' );
		}

		// Save
		if (!$table->store()) {
			$this->_mainframe->redirect( 'index.php?option=com_jam&view=templates', $table->getError(), 'error' );
		}

		// Give a successfull message
		$this->_mainframe->redirect( 'index.php?option=com_jam&view=templates', JText::_( 'Successfully saved'), 'message' );
	}

	function edithtml()
	{
		JRequest::setVar( 'layout', 'fileslist');
		JRequest::setVar( 'path', 'html', 'post');
		$this->_name = 'JAM';
		parent::display();
	}

	function editcss()
	{
		JRequest::setVar( 'layout', 'fileslist');
		JRequest::setVar( 'path', 'css', 'post');
		$this->_name = 'JAM';
		parent::display();
	}

	function savetemplate()
	{
		$base		= JPATH_PLUGINS.DS.'jam-templates';
		$template	= JRequest::getVar( 'template', '', 'post');
		$path		= JRequest::getVar( 'path', '', 'post');
		$file		= JRequest::getVar( 'file', '', 'post');
		$filepath	= $base.DS.$template.DS.$path.DS.$file;

		// Save the file
		jimport('joomla.filesystem.file');
		$content	= JRequest::getVar( 'content', '', 'post', 'string', JREQUEST_ALLOWRAW);
		$return		= JFile::write( $filepath, $content);
		
		if (!$return) {
			$this->_mainframe->redirect( 'index.php?option=com_jam&view=templates', JText::_('Error saving file'), 'error' );
		}

		$this->_mainframe->redirect( 'index.php?option=com_jam&view=templates', JText::_('File Saved'), 'message' );
	}

	function config()
	{
		// Get the database table of the our component
		$table = JTable::getInstance('component');
		if (!$table->loadByOption('com_jam')) {
			$this->_mainframe->redirect( 'index.php?option=com_jam&view=configuration', JText::_('ERRORELEMENTNOTFOUND'), 'error' );
		}

		// Get the vars posted by the form
		$post = JRequest::get('post');
		$post['option']						= 'com_jam';
		$post['params']['hideusers']		= str_replace( ' ', '', $post['params']['hideusers'] );
		$table->bind( $post);

		// Pre-save checks
		if (!$table->check()) {
			$this->_mainframe->redirect( 'index.php?option=com_jam&view=configuration', $table->getError(), 'error' );
		}

		// Save
		if (!$table->store()) {
			$this->_mainframe->redirect( 'index.php?option=com_jam&view=configuration', $table->getError(), 'error' );
		}

		// Give a succesfull message
		$this->_mainframe->redirect( 'index.php?option=com_jam&view=configuration', JText::_('Successfully saved'), 'message' );
	}

	/* Frontend function */
	function savemessage()
	{
		// Load the front-end language
		$lang =& Jfactory::getLanguage();
		$lang->load( 'com_jam', JPATH_SITE);

		require_once( JPATH_COMPONENT_SITE.DS.'controllers'.DS.'savemessage.php');	
		$controller = new JAMController( array('base_path' => JPATH_COMPONENT_SITE) );
		$controller->savemessage();
	}

	/* Frontend function */
	function action()
	{
		// Load the front-end language
		$lang =& Jfactory::getLanguage();
		$lang->load( 'com_jam', JPATH_SITE);

		require_once( JPATH_COMPONENT_SITE.DS.'controllers'.DS.'action.php');	
		$controller = new JAMController( array('base_path' => JPATH_COMPONENT_SITE) );
		$controller->action();	
	}
}
?>