<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Load the general model
require_once( JPATH_COMPONENT.DS.'models'.DS.'model.php' );

class JAMModelStatistics extends JAMModel
{
	/**
	 * Get data from the messages table
	 *
	 * @access	public
	 * @return	object
	 */
	function tableMessages()
	{
		$db		=& $this->db;

		$query	= 'SELECT COUNT(id) AS total,'
				. ' (SELECT COUNT(id) FROM `#__jam` WHERE draft) AS draft,'
				. ' (SELECT COUNT(id) FROM `#__jam` WHERE !sid) AS information,'
				. ' (SELECT COUNT(id) FROM `#__jam` WHERE system) AS system,'
				. ' (SELECT COUNT(id) FROM `#__jam` WHERE attachments) AS attachments,'
				. ' (SELECT COUNT(id) FROM `#__jam` WHERE outbox) AS senders,'
				. ' (SELECT COUNT(id) FROM `#__jam` WHERE outbox = 2) AS archive,'
				. ' (SELECT COUNT(id) FROM `#__jam` WHERE outbox < 0) AS trash'
				. ' FROM `#__jam`';

		$db->setQuery($query);
		return $db->loadObject();
	}

	/**
	 * Get data from the receivers table
	 *
	 * @access	public
	 * @return	object
	 */
	function tableReceivers()
	{
		$db		=& $this->db;

		$query	= 'SELECT COUNT(id) AS total,'
				. ' (SELECT COUNT(id) FROM `#__jam_receivers` WHERE inbox = 2) AS archive,'
				. ' (SELECT COUNT(id) FROM `#__jam_receivers` WHERE inbox < 0) AS trash,'
				. ' (SELECT COUNT(id) FROM `#__jam_receivers` WHERE !state) AS s_new,'
				. ' (SELECT COUNT(id) FROM `#__jam_receivers` WHERE state) AS s_read'
				. ' FROM `#__jam_receivers`';

		$db->setQuery($query);
		return $db->loadObject();
	}

	/**
	 * Get data from the tags table
	 *
	 * @access	public
	 * @return	object
	 */
	function tableTags()
	{
		$db		=& $this->db;

		$query	= 'SELECT COUNT(id) AS total'
				. ' FROM `#__jam_tags`';

		$db->setQuery($query);
		return $db->loadObject();
	}

	/**
	 * Receivers Top 5
	 *
	 * @access		public
	 * @return		array
	 */
	function getTopReceivers()
	{
		$db		=& $this->db;

		$query	= 'SELECT amount, '.JAMUsers::SQLUserLong().' AS user'
				. ' FROM (SELECT COUNT(r.id) AS amount, r.rid'
				. '  FROM `#__jam_receivers` AS r'
				. '  GROUP BY r.rid'
				. '  ORDER BY amount DESC'
				. '  LIMIT 5) AS r'
				. ' LEFT JOIN `#__users` AS u ON u.id = r.rid';
		$db->setQuery($query);
		return $db->loadAssocList();
	}

	/**
	 * Senders Top 5
	 *
	 * @access		public
	 * @return		array
	 */
	function getTopSenders()
	{
		$db		=& $this->db;

		$query	= 'SELECT amount, '.JAMUsers::SQLUserLong().' AS user'
				. ' FROM (SELECT COUNT(m.id) AS amount, m.sid'
				. '  FROM `#__jam` AS m'
				. '  GROUP BY m.sid'
				. '  ORDER BY amount DESC'
				. '  LIMIT 5) AS m'
				. ' LEFT JOIN `#__users` AS u ON u.id = m.sid';
		$db->setQuery($query);
		return $db->loadAssocList();
	}

	/**
	 * Get size of JAM's tables
	 *
	 * @access		public
	 * @return		array
	 */
	function getTablesSize()
	{
		$db		=& $this->db;
		$prefix	= $db->getPrefix();

		// Messages table
		$query	= 'SHOW TABLE STATUS LIKE \''.$prefix.'jam\'';
		$db->setQuery($query);
		$result	= $db->loadAssoc();
		$size	= $result['Data_length'] + $result['Index_length'];

		// Receivers table
		$query	= 'SHOW TABLE STATUS LIKE \''.$prefix.'jam_receivers\'';
		$db->setQuery($query);
		$result	= $db->loadAssoc();
		$size	+= $result['Data_length'] + $result['Index_length'];

		// Settings table
		$query	= 'SHOW TABLE STATUS LIKE \''.$prefix.'jam_settings\'';
		$db->setQuery($query);
		$result	= $db->loadAssoc();
		$size	+= $result['Data_length'] + $result['Index_length'];

		// Tags table
		$query	= 'SHOW TABLE STATUS LIKE \''.$prefix.'jam_tags\'';
		$db->setQuery($query);
		$result	= $db->loadAssoc();
		$size	+= $result['Data_length'] + $result['Index_length'];

		// Create from the size a more human reabable sting
		if ($size >= 1048576) {
			$size = round( $size/1048576, 2).' '.JText::_('MB');
		} else {
			$size = round( $size/1024, 2).' '.JText::_('KB');
		}

		return $size;
	}
}