<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Load the general model
require_once( JPATH_COMPONENT.DS.'models'.DS.'model.php' );

class JAMModelInstallation extends JAMModel
{
	function CheckTables()
	{
		$db		=& $this->db;
		$prefix	= $db->getPrefix();
		$db->setQuery( "SHOW TABLES LIKE '".$prefix."jam%';");
		$result	= $db->loadResultArray();
		
		$tables	= array(
					'jam' => in_array($prefix.'jam', $result) ? true : false,
					'receivers' => in_array($prefix.'jam_receivers', $result) ? true : false,
					'settings' => in_array($prefix.'jam_settings', $result) ? true : false,
					'tags' => in_array($prefix.'jam_tags', $result) ? true : false
				);
		return $tables;
	}

	function getTableColumns( $name )
	{
		$db =& $this->db;
		$db->setQuery( 'SHOW COLUMNS FROM #__'.$name.';');
		return $db->loadAssocList('Field');
	}

	function CreateTable( $name, $data )
	{
		$db			=& $this->db;
		$character	= $db->hasUTF() ? ' CHARACTER SET `utf8` COLLATE `utf8_general_ci`' : NULL;
		$query		= 'CREATE TABLE `#__'.$name.'` ('
					. $data
					. ') TYPE=MyISAM'.$character.';';
		$db->setQuery( $query );
		return $db->query() ? true : $db->stderr();
	}

	function AlterTable( $name, $data )
	{
		$db =& $this->db;
		$db->setQuery( "ALTER TABLE `#__$name` $data;");
		return $db->query() ? true : $db->stderr();
	}
}