<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Load the general model
require_once( JPATH_COMPONENT.DS.'models'.DS.'model.php' );

class JAMModelAll extends JAMModel
{
	/**
	 * Count Messages
	 *
	 * @parram array	$where. Contains the WHERE parts
	 * @access			public
	 * @return			int
	 */
	function countMessages($where)
	{
		$db		=& $this->db;

		$where	= $where ? ' WHERE '.implode( ' AND ', $where) : '';

		$query	= 'SELECT COUNT( DISTINCT m.id)'
				. ' FROM `#__jam` AS m'
				. ' LEFT JOIN `#__jam_receivers` AS r ON r.mid = m.id'
				. ' LEFT JOIN `#__users` AS u ON u.id = m.sid OR u.id = r.rid'
				. $where;
		$db->setQuery($query);
		$result	= $db->loadResult();

		return $result;
	}

	/**
	 * Get messages
	 *
	 * @parram array	$where. Contains WHERE parts
	 * @parram string	$order. Contains the order string
	 * @parram int		$limitstart. Contains the number to start
	 * @parram int		$limit. Contains the number to end
	 * @access			public
	 * @return			object
	 */
	function &getMessages($where, $order, $limitstart, $limit)
	{
		$db		=& $this->db;

		$where	= $where ? ' WHERE '.implode( ' AND ', $where) : '';

		$query	= 'SELECT m.id, m.sid, m.subject, m.message, m.datetime, m.draft, m.priority, m.system, m.attachments, r.state,'
				. ' GROUP_CONCAT(DISTINCT '.JAMUsers::SQLUserLong().' ORDER BY '.JAMUsers::SQLUserShort().' SEPARATOR \', \') AS user'
				. ' FROM `#__jam` AS m'
				. ' LEFT JOIN `#__jam_receivers` AS r ON r.mid = m.id'
				. ' LEFT JOIN `#__users` AS u ON u.id = m.sid OR u.id = r.rid'
				. $where
				. ' GROUP BY m.id'
				. ' ORDER BY '.$order;
		$db->setQuery($query, $limitstart, $limit);
		$result	= $db->loadObjectList();

		return $result;
	}

	/**
	 * Get a message
	 *
	 * @parram int	$id. Contains the message-id
	 * @access		public
	 * @return		object
	 */
	function &getMessage($id)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$query	= 'SELECT m.*, r.rid, r.inbox,'
				. ' GROUP_CONCAT('.JAMUsers::SQLUserLong().' ORDER BY '.JAMUsers::SQLUserShort().' SEPARATOR \', \') AS user,'
				. ' GROUP_CONCAT(CAST(r.state AS CHAR) SEPARATOR \',\') AS state'
				. ' FROM `#__jam` AS m'
				. ' LEFT JOIN `#__jam_receivers` AS r ON r.mid = m.id'
				. ' LEFT JOIN `#__users` AS u ON u.id = r.rid'
				. ' WHERE m.id = '.$id
				. ' GROUP BY m.id';
		$db->setQuery($query);
		$result	= $db->loadObject();

		return $result;
	}
}