<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMHelperStatistics extends JObject
{
	/**
	 * Get the size of the attachments folder
	 *
	 * @access				public
	 * @return				string
	 */
	function getSizeAttachmentsFolder()
	{
		$folder = JPATH_COMPONENT_SITE.DS.'attachments';
		$size = JAMHelperStatistics::_getSizeFolder($folder);

		// Create from the size a more human reabable sting
		if ($size >= 1048576) {
			$size = round( $size/1048576, 2).' '.JText::_('MB');
		} else {
			$size = round( $size/1024, 2).' '.JText::_('KB');
		}

		return $size;
 	}

	function _getSizeFolder($path)
	{
		$size = 0;
		$dir = opendir($path);
		while($file = readdir($dir))
		{
			// If we are handeling a file add the size of that file
			if (is_file($path.DS.$file)) {
				$size += filesize($path.DS.$file);
			}

			// If we are handeling a folder we have to call this function again
			if (is_dir($path.DS.$file) && $file != '.' && $file != '..') {
				$size += JAMHelperStatistics::_getSizeFolder( $path.DS.$file);
			}
		}
		closedir($dir);

		return $size;
	}

	/**
	 * Get %
	 *
	 * @parram int	$value.
	 * @parram int	$total.
	 * @access		public
	 * @return		string
	 */
	function getProcent($value, $total)
	{
		return $value.' - '.round( $value / $total * 100 ).'%';
	}
}
?>