<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMHelperInstallation
{
	 function config()
	 {
	 	// Get the database table of the our component
		$table = JTable::getInstance('component');
		if (!$table->loadByOption( 'com_jam')) {
			return array( 'ERRORELEMENTNOTFOUND', 'red' );
		}

		// Add the config to the table object
		$params	= array(
				#General
				'installed'=>'1',
				'template_default'=>'classic',
				'displayuser'=>'3',
				'profile'=>'0',
				'hideusers'=>'admin,administrator',
				'blocking'=>'1',
				'notification_message'=>'1',
				'notification_system'=>'1',
				'notification_system_message'=>'1',
				#Group specific
				'access_18'=>'1','access_19'=>'1','access_20'=>'1','access_21'=>'1','access_23'=>'1','access_24'=>'1','access_25'=>'1',
				'messageslimit_18'=>'50','messageslimit_19'=>'100','messageslimit_20'=>'100','messageslimit_21'=>'100','messageslimit_23'=>'200','messageslimit_24'=>'500','messageslimit_25'=>'500',
				'lengthlimit_18'=>'5000','lengthlimit_19'=>'50000','lengthlimit_20'=>'50000','lengthlimit_21'=>'50000','lengthlimit_23'=>'1000000','lengthlimit_24'=>'1000000','lengthlimit_25'=>'1000000',
				'attachments_18'=>'1','attachments_19'=>'2','attachments_20'=>'2','attachments_21'=>'2','attachments_23'=>'5','attachments_24'=>'5','attachments_25'=>'5',
				'attachmentsizelimit_18'=>'51200','attachmentsizelimit_19'=>'102400','attachmentsizelimit_20'=>'102400','attachmentsizelimit_21'=>'102400','attachmentsizelimit_23'=>'1048576','attachmentsizelimit_24'=>'1048576','attachmentsizelimit_25'=>'1048576',
				'notification_18'=>'1', 'notification_19'=>'1', 'notification_20'=>'1', 'notification_21'=>'1', 'notification_23'=>'1', 'notification_24'=>'1', 'notification_25'=>'1',
				'massmessage_18'=>'0', 'massmessage_19'=>'0', 'massmmessage_20'=>'0', 'massmessage_21'=>'0', 'massmessage_23'=>'1', 'massmessage_24'=>'1', 'massmessage_25'=>'1',
				'systemmessage_18'=>'0', 'systemmessage_19'=>'0', 'systemmessage_20'=>'0', 'systemmessage_21'=>'0', 'systemmessage_23'=>'1', 'systemmessage_24'=>'1', 'systemmessage_25'=>'1',
				'informationmessage_18'=>'0', 'informationmessage_19'=>'0', 'informationmessage_20'=>'0', 'informationmessage_21'=>'0', 'informationmessage_23'=>'1', 'informationmessage_24'=>'1', 'informationmessage_25'=>'1',
				'userlist_18'=>'1', 'userlist_19'=>'1', 'userlist_20'=>'1', 'userlist_21'=>'1', 'userlist_23'=>'1', 'userlist_24'=>'1', 'userlist_25'=>'1'
			);
		$table->bind( array( 'params' => $params) );

		// Pre-save checks
		if (!$table->check()) {
			return array( $table->getError(), true );
		}

		// Save the config
		if (!$table->store()) {
			return array( $table->getError(), true );
		}

		return true;
	}

	function getTableData( $table )
	{
		if ($table == 'jam')
		{
			$data	= "`id` int(11) AUTO_INCREMENT NOT NULL,"
					. "`sid`  int(11) NOT NULL,"
					. "`outbox` tinyint(2) default '1',"
					. "`subject` text NOT NULL,"
					. "`message` text NOT NULL,"
					. "`datetime` datetime NOT NULL,"
					. "`draft` tinyint(1) DEFAULT '0',"
					. "`priority` tinyint(1) DEFAULT '2',"
					. "`system` tinyint(1) DEFAULT '0',"
					. "`attachments` tinyint(1) DEFAULT '0',"
					. "PRIMARY KEY (`id`),"
					. "INDEX `sender` (`sid`,`outbox`)";
		}

		if ($table == 'jam_receivers')
		{
			
			$data	= "`id` int(11) AUTO_INCREMENT NOT NULL,"
					. "`mid` int(11) NOT NULL,"
					. "`rid` int(11) NOT NULL,"
					. "`inbox` tinyint(2) default '1',"
					. "`state` tinyint(1) default '0',"
					. "PRIMARY KEY (`id`),"
					. "INDEX `mid` (`mid`),"
					. "INDEX `receiver` (`rid`,`inbox`)";
		}

		if ($table == 'jam_settings')
		{
			$data	= "`userid` int(11) NOT NULL,"
					. "`dateformat` varchar(14) default '%d-%b-%Y %H:%M',"
					. "`notification` tinyint(1) default '0',"
					. "`notification_message` tinyint(1) default '0',"
					. "`template` VARCHAR(30) default NULL,"
					. "`blocked` text default NULL,"
					. "PRIMARY KEY (`userid`)";
		}

		if ($table == 'jam_tags')
		{
			$data	= "`id` int(11) AUTO_INCREMENT NOT NULL,"
					. "`uid` int(11) NOT NULL,"
					. "`tag` varchar(255) default NULL,"
					. "`mids` text default NULL,"
					. "PRIMARY KEY (`id`),"
					. "INDEX `uid` (`uid`)";
		}

		return $data;
	}
}
?>