<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMHelperAll
{
	/**
	 * SQL Search part
	 *
	 * @parram string	$string.
	 * @access			public
	 * @return			string
	 */
	function SQLSearch($search)
	{
		$config	=& JAMConfig::getConfig();
		$display= $config->get( 'displayuser');
		$array	= explode( ' ', $search);
		$parts	= array();
			
		for ($i = 0, $t = count($array); $i < $t; $i++)
		{
			$part = $array[$i];

			if ($display == '3' || $display == '4') {
				$parts[]	= "((u.username LIKE '%$part%' OR u.name LIKE '%$part%')"
							. " OR m.subject LIKE '%$search%'"
							. " OR m.message LIKE '%$search%')";
			} else {
				$parts[]	= "( ".JAMUsers::SQLUserShort()." LIKE '%$part%'"
							. " OR m.subject LIKE '%$search%'"
							. " OR m.message LIKE '%$search%')";
			}
		}

		$string = implode( ' AND ', $parts);
		return '('.$string.')';
	}

	/**
	 * Filter state
	 *
	 * @parram int	$filter. Contains the parram for the filter
	 * @access		public
	 * @return		string
	 */
	function Filter_state($filter)
	{
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');

		// New
		if ($filter == '1') {
			$where = "r.state = '0'";
		}
		// Read
		else if ($filter == '2') {
			$where = "r.state = '1'";
		}
		// Draft
		else if ($filter == '3') {
			$where = "m.draft = '1'";
		}
		// System
		else if ($filter == '4') {
			$where = "m.system = '1'";
		}
		// Information message
		else if ($filter == '5') {
			$where = "m.sid = '1'";
		}

		return $where;
	}

	/**
	 * Filter state html
	 *
	 * @parram int		$state. Contains the state-parameters
	 * @parram array	$array. Contains the list-parameters (optional)
	 * @access			public
	 * @return			string
	 */
	function Filter_state_html($state, $array = array())
	{
		$list = array();
		$list[] = JHTML::_( 'select.option', '0', JText::_( 'All') );
		$list[] = JHTML::_( 'select.option', '1', JText::_( 'New') );
		$list[] = JHTML::_( 'select.option', '2', JText::_( 'Read') );
		$list[] = JHTML::_( 'select.option', '3', JText::_( 'Draft') );
		$list[] = JHTML::_( 'select.option', '4', JText::_( 'System message') );
		$list[] = JHTML::_( 'select.option', '5', JText::_( 'Information message') );

		return JHTML::_( 'select.genericlist', $list, 'filter_state', 'size="1" class="inputbox" onchange="document.adminForm.submit();"', 'value', 'text', $state);
	}

	/**
	 * Filter order html
	 *
	 * @parram string	$order. Contains the list-parameter
	 * @access			public
	 * @return			string
	 */
	function Filter_order_html($order)
	{
		$list = array();
		$list[] = JHTML::_( 'select.option', JAMUsers::SQLUserShort(),	JText::_( 'User'));
		$list[] = JHTML::_( 'select.option', 'm.subject',				JText::_( 'Subject'));
		$list[] = JHTML::_( 'select.option', 'm.datetime',				JText::_( 'Date and Time'));

		return JHTML::_( 'select.genericlist', $list, 'filter_order', 'size="1" class="inputbox" onchange="document.adminForm.submit();"', 'value', 'text', $order);
	}

	/**
	 * Filter order Dir html
	 *
	 * @parram string	$dir. Contains the list-parameter
	 * @access			public
	 * @return			string
	 */
	function Filter_order_Dir_html($dir)
	{
		$list = array();
		$list[] = JHTML::_( 'select.option', 'ASC',		JText::_( 'Ascending'));
		$list[] = JHTML::_( 'select.option', 'DESC',	JText::_( 'Descending'));

		return JHTML::_( 'select.genericlist', $list, 'filter_order_Dir', 'size="1" class="inputbox" onchange="document.adminForm.submit();"', 'value', 'text', $dir);
	}
}