<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.controller');

class JAMAdminController extends JController
{
	function display()
	{
		// If the view is a message view, use the frontend controller
		$viewName	= JRequest::getVar( 'view', 'panel');
		$views		= array( 'archive', 'export', 'inbox', 'new', 'outbox', 'read', 'settings', 'trash', 'usersearch');
		if (in_array($viewName, $views)) {
			// Load the front-end language
			$lang =& Jfactory::getLanguage();
			$lang->load( 'com_jam', JPATH_SITE);

			require_once( JPATH_COMPONENT_SITE.DS.'controller.php');	
			$controller = new JAMController( array('base_path' => JPATH_COMPONENT_SITE) );
			$controller->display();
			return;
		}

		$document	=& JFactory::getDocument();
		$baseurl	= JURI::root();

		/**
		 * Load a view
		 */
		// Get some vars for the view
		$viewLayout = JRequest::getVar( 'layout', 'default');
		$viewType   = $document->getType();
		// If the active user is not an admin, he is not allowed to access some pages
		$user		=& JFactory::getUser();
		$views		= array('all', 'clean', 'configuration', 'installation', 'templates');
		if ($user->get('gid') < 24 && in_array( $viewName, $views )) {
			$viewName = 'panel';
		}
		// Get the view
		$view =& $this->getView( $viewName, $viewType, 'JAMView');
		// Set the layout
		$view->setLayout($viewLayout);

		/**
		 * Display the view
		 */
		$view->display();
	}

	function ReturnPage()
	{
		// Load the front-end language
		$lang =& Jfactory::getLanguage();
		$lang->load( 'com_jam', JPATH_SITE);

		require_once(JPATH_COMPONENT_SITE.DS.'controller.php');	
		$controller = new JAMController( array('base_path' => JPATH_COMPONENT_SITE) );
		$controller->ReturnPage();
	}

	/* Frontend function */
	function pure()
	{
		// Load the front-end language
		$lang =& Jfactory::getLanguage();
		$lang->load( 'com_jam', JPATH_SITE);

		require_once( JPATH_COMPONENT_SITE.DS.'controllers'.DS.'pure.php');	
		$controller = new JAMController( array('base_path' => JPATH_COMPONENT_SITE) );
		$controller->display();
	}

	/* Frontend function */
	function attachment()
	{
		require_once( JPATH_COMPONENT_SITE.DS.'controllers'.DS.'savemessage.php');	
		$controller = new JAMController( array('base_path' => JPATH_COMPONENT_SITE) );
		$controller->attachment();
	}
}
?>