<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

defined( '_JEXEC') or die('Restricted access'); // no direct access
define( '_JAM_VERSION', 'v1.0.4 Hotfix');

// Load the loader librarie
require_once( JPATH_COMPONENT_SITE.DS.'libraries'.DS.'load.php');

// Only for users who are allowed
$config	=& JAMConfig::getConfig();
$user	=& JFactory::getUser();
$gid	= $user->get('gid');
if ( !$config->get('access_'.$gid, 1) ) {
	global $mainframe;
	$mainframe->redirect( 'index.php?option=com_jam&view=panel', JText::_( 'ALERTNOTAUTH'));
	return;
}

// Get the task and the controller variable
$task		= JRequest::getWord( 'task', 0, 'post');
$controller	= JRequest::getWord( 'controller');

// Load the right controller
if ($task && $task != 'returnpage') {
	$controller = 'task.controller.php';
} else {
	if ($controller == 'pure') {
		$task = 'pure';
	} else if ($controller == 'attachment') {
		$task = 'attachment';
	}
	$controller = 'controller.php';
}
require_once( JPATH_COMPONENT.DS.$controller );

// If JAM has not completed the installation yet, complete it still
if (!$config->get('installed')) {
	JRequest::setVar( 'view', 'installation');
}

// Create the controller
$controller = new JAMAdminController();

// Perform the requested task
$controller->execute( $task);

// Redirect if set by the controller
$controller->redirect();
?>